﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ZSMusic.Model
{
    /// <summary>
    /// 音乐源实体类
    /// </summary>
    [Serializable]
    public class MusicSource
    {
        /// <summary>
        /// 显示名称
        /// </summary>
        public string DisplayName { get; set; }
        /// <summary>
        /// 音乐类名
        /// </summary>
        public string Value { get; set; }
        /// <summary>
        /// 是否可用
        /// </summary>
        public bool Enabled { get; set; }
        /// <summary>
        /// 是否启用本地解析
        /// </summary>
        public bool SupportLocal { get; set; }
        /// <summary>
        /// 是否启用在线解析
        /// </summary>
        public bool SuppwotWeb { get; set; }
        /// <summary>
        /// 是否需要互联网连接
        /// </summary>
        public bool NeedInternet { get; set; }
        public MusicSource() { }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="name">显示名称</param>
        /// <param name="value">音乐类名</param>
        /// <param name="en">是否可用</param>
        /// <param name="local">是否启用本地解析</param>
        /// <param name="web">是否启用在线解析</param>
        public MusicSource(string name, string value, bool en = true, bool local = true, bool web = true, bool need = true)
        {
            DisplayName = name;
            Value = value;
            Enabled = en;
            SupportLocal = local;
            SuppwotWeb = web;
            NeedInternet = need;
        }
        public override string ToString()
        {
            return DisplayName;
        }
    }
}
